﻿/*
VERSION:		1.9

USAGE:
	#include "walk.as"
	player_mc.walk_obj = makeWalk( player_mc );
	
	onUnload = function(){
		clearInterval(walk_obj.loopInterval);
	}
	
NOTES:
	This system has hooks for these collision and sprite systems:
		MakeSprite()			(Sprite system 1 - RpgMaker)
		WalkCollision
	
USING THE SPRITE SYSTEM:
	If you specify the  playerSprite_mc  parameter when making the walk system,
	it'll automatically set the direction and animation of the sprite as you move the character.
	
ADDING COLLISION:
	A collision system can be added like this:
		walk_obj.collision = new WalkCollision( player_mc, walk_obj, collision_array, -8, -8 );
	The walk_obj is this walk system.
*/
makeWalk = function( player_mc, playerSprite_mc )
{
	// player_mc				(to alter their position)
	// playerSprite_mc		(to alter the pose of their sprite system)
	
	// create container
	var _this = new Object();
	
	// walkSpeed
	_this.walkSpeed = 3;		// pixels per frame
	
	_this.playerSprite_mc = playerSprite_mc;
	
	
	//default walk buttons.  This allows the keys to be changed externally.
	_this.up_key = Key.UP;
	_this.down_key = Key.DOWN;
	_this.left_key = Key.LEFT;
	_this.right_key = Key.RIGHT;
	
	
	
	// Make a looping function
	_this.loop = function()
	{
		_this.xVel = 0;
		_this.yVel = 0;
		
		
		// detect vert keys
		if( Key.isDown(_this.down_key) )
		{
			_this.yVel = 1;
			_this.playerSprite_mc.setDirection("down");
		}
		else if( Key.isDown(_this.up_key) )
		{
			_this.yVel = -1;
			_this.playerSprite_mc.setDirection("up");
		}
		
		
		// detect horz keys
		if( Key.isDown(_this.right_key) )
		{
			_this.xVel = 1;
			_this.playerSprite_mc.setDirection("right");
		}
		else if( Key.isDown(_this.left_key) )
		{
			_this.xVel = -1;
			_this.playerSprite_mc.setDirection("left");
		}
		
		
		
		_this.xVel *= _this.walkSpeed;
		_this.yVel *= _this.walkSpeed;
		
		// Apply externally-defined collision
		_this.collision.run();
		
		// start or stop the walk animation
		if (_this.xVel || _this.yVel)
		{
			// is moving
			_this.playerSprite_mc.setAnim( true );
		}else{
			// is not moving
			_this.playerSprite_mc.setAnim( false );
		}
		
		// Move the player
		player_mc._x += _this.xVel;
		player_mc._y += _this.yVel;
		
	}// loop()
	_this.loopInterval = setInterval( _this.loop, 1000/30 );
	
	
	
	// return this system
	return _this;
}// makeWalk()